#ifndef RATNET2_RAT_PLUGIN_H
#define RATNET2_RAT_PLUGIN_H

#include "RatPlugin.h"
#include "ANN.h"
#include "Debug.h"

extern "C" _EXPORT RatPlugin *instantiate_rat();

// BackpropRatPlugin.h
// backprop rat brain
// CGP; 6/24/00
// CGP; 7/2/00; Modified to use API
// CGP; 11/12/00; Modified to use current API.
// CGP; 12/24/00; Modified to use version 2 of rat API.
//		The rat no longer has explicit message receipt from the experimenter.
//		This is hidden in RatPlugin.cpp.

class RATNET2RatPlugin : public RatPlugin {
  public:
    int PLUGIN_API_Version() {return RAT_API_VER;};
    
    RATNET2RatPlugin(PortMessage *expRatPort, DatabaseMessage *dbMsg,
    	RatEnvMessage *ratEnvMsg, DebugServer *bugServer);
    ~RATNET2RatPlugin();
    
    long PLUGIN_Start();
          
  private:
  	void Step();
  	bool RotateUntilOpen();
  	void GetAlternativeViews(float *view1, float *view2);
  	CObXPlex *ConvertFromView(float *view);
  	double VectorDistance(CObXPlex* v1, CObXPlex* v2);
  	void SaveViewRecord(float *view, int16 subType);
  	void SaveDistanceRecord(float distA1, float distA2);
  	void MoveToMazeCenter();
	float *GetStartArmView();
  	
    ANN neuralNet; // the rat's neural network (i.e., his or her cognition)
	int trialNumber; // for evaluation purposes
	int16 trialType; // for evaluation
};

#endif
